<?php


// 1. Add a custom interval of 5 minutes
add_filter('cron_schedules', 'sc_add_cron_interval');
function sc_add_cron_interval($schedules)
{
    $schedules['every_5_minutes'] = [
      'interval' => 300, // 300 seconds = 5 minutes
      'display'  => __('Every 5 Minutes')
    ];
    return $schedules;
}

// 2. Schedule the event on plugin activation
register_activation_hook(__FILE__, 'sc_schedule_cron_job');
function sc_schedule_cron_job()
{
    if (!wp_next_scheduled('sc_cron_hook')) {
        wp_schedule_event(time(), 'every_5_minutes', 'sc_cron_hook');
    }
}

// 3. Clear the cron job on plugin deactivation
register_deactivation_hook(__FILE__, 'sc_clear_cron_job');
function sc_clear_cron_job()
{
    wp_clear_scheduled_hook('sc_cron_hook');
}

// 4. Hook your actual task to the event
add_action('sc_cron_hook', 'sc_run_cron_task');
function sc_run_cron_task()
{
    // Your task logic here
    // error_log('[SC CRON] Task executed at ' . current_time('mysql'));
    sc_verify_registration();

    // record the last cron execution time...
    update_option('sc_last_cron_execution', current_time('mysql'));
}
