<?php


class SC_Command_Matomo_Has_Tracker extends SC_Command_Base
{
    public function execute()
    {
        try {
            if (function_exists('sc_matomo_has_tracking_code')) {
                $hasTracker   = sc_matomo_has_tracking_code();
                $trackingCode = sc_matomo_get_tracking_code();
                $trackingCodeCanRender = sc_matomo_can_render_tracking_code();

                // return the command response...r
                $response = [
                  'success' => true,
                  'message' => 'The plugin has verified if the site has a tracking code installed.',
                  'data'    => [
                    'has_tracker'   => $hasTracker,
                    'tracking_code' => $trackingCode,
                    'security_pass' => $trackingCodeCanRender
                  ]
                ];
                return $response;
            } else {
                throw new Exception('The plugin could not verify if the site has a tracking code installed.');
            }
        } catch (Exception $e) {
            $response = [
              'success' => false,
              'message' => 'The plugin could not verify if the site has a tracking code installed.',
              'data'    => []
            ];
            return $response;
        }
    }
}
