<?php

/**
 * Command to get WordPress site metadata including version, updates, users, and pages.
 */
class SC_Command_WP_Getmeta extends SC_Command_Base {

  /**
   * Retrieve the favicon URL for the site.
   *
   * This method first attempts to get the favicon ID from the WordPress Customizer
   * (typically stored via `get_theme_mod('favicon')`). If a valid attachment ID is found,
   * it returns the associated image URL using `wp_get_attachment_url()`. 
   * If no custom favicon is set, it falls back to the default site icon URL 
   * using `get_site_icon_url()`.
   *
   * @return string The URL of the favicon image.
   */
  private function get_favicon_url() {
    // Get the favicon URL from the customizer settings
    // $favicon_id = get_theme_mod('favicon'); // Replace with the correct option name if different
    // if ($favicon_id) {
    //   return wp_get_attachment_url($favicon_id);
    // }

    // Fallback to the default favicon location
    return get_site_icon_url();
  }

  /**
   * Execute the WP metadata command.
   *
   * @return array An associative array of site metadata.
   */
  public function execute() {
    include_once ABSPATH . 'wp-admin/includes/update.php'; // Ensure update functions are loaded

    $core_updates = get_core_updates();
    $update_available = !empty($core_updates) && $core_updates[0]->response === 'upgrade';

    $info = [
      'wp_version'      => get_bloginfo('version'),
      'update_needed'   => $update_available,
      'users_count'     => count_users()['total_users'],
      'pages_count'     => wp_count_posts('page')->publish,
      "connect_version" => SC_PLUGIN_VERSION,
      "favicon_url"     => $this->get_favicon_url(),
      "site_title"      => get_bloginfo('name'),
      "site_subtitle"   => get_bloginfo('description')
    ];
 
    return array(
      "success" => true,
      "message" => "The command has executed.",
      "data"    => $info
    );
  }
}
