<?php

/**
 * Command to get all WordPress users and their metadata.
 */
class SC_Command_Users_Get extends SC_Command_Base {

  /**
   * Execute the command to get all users.
   *
   * @return array An associative array containing the result of the command execution.
   */
  public function execute() {
    // Include necessary files (not strictly necessary here)
    include_once ABSPATH . 'wp-includes/user.php'; // Ensure user functions are loaded

    // Get all users
    $users = get_users();
    $user_data = [];

    // Loop through users and collect relevant data
    foreach ($users as $user) {
      $user_data[] = [
        'ID'          => $user->ID,
        'user_login'  => $user->user_login,
        'user_email'  => $user->user_email,
        'first_name'  => get_user_meta($user->ID, 'first_name', true),
        'last_name'   => get_user_meta($user->ID, 'last_name', true),
        'display_name' => $user->display_name,
        'role'        => implode(', ', $user->roles),
      ];
    }

    return array(
      'success' => true,
      'message' => 'All users retrieved successfully.',
      'data'    => $user_data,
    );
  }
}
