<?php
/**
 * Plugin Name: 121 CONNECT
 * Description: Registers this WordPress site with a backend service using RSA encryption.
 * Version: 1.0.7
 * Author: 121 Digital Services Limited
 */
 
 // THIS IS THE UPDATE THAT HAS BEEN PUSHED!

defined('ABSPATH') || exit;

// basic define the plugin version...
define("SC_PLUGIN_VERSION", "1.0.7");

define('SC_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('SC_PLUGIN_URL', plugin_dir_url(__FILE__));
define('SC_PLUGIN_FILE', plugin_basename(__FILE__)); // Add this to your main plugin file

define('SC_REMOTE_API_BASE', "https://api.121domains.co.uk/api.php");
define('SC_UPDATE_API_BASE', "https://wp-update-service.121domains.co.uk/121connect/");

// require the plugin update lib.
require_once SC_PLUGIN_PATH . '/plugin-update-checker/plugin-update-checker.php';
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

function sc_die(string $errorMessage) {
  $errorHtml = "<h1><img width='250px' src='".SC_PLUGIN_URL."/static/brand_logo.svg'></h1><br>";
  $errorHtml.= "<b>An error has been reported:</b> <br>";
  $errorHtml.= "<span>". $errorMessage . "</span>";
  $errorHtml.= "<h1></h1>";

  // throw the error through wordpress die functionality.  
  wp_die($errorHtml);

}

// init the plugin update checker...
try {
  $pluginUpdateChecker = PucFactory::buildUpdateChecker(
    SC_UPDATE_API_BASE . 'metadata.json',
    __FILE__, // This is your main plugin file
    '121_connect' // Slug of your plugin
  );
  if(!isset($pluginUpdateChecker)) {
    throw new Exception('Could not init 121Connect plugin update service.');
  }
}
catch(Exception $e) {
  sc_die($e->getMessage());
}

// require_once SC_PLUGIN_PATH . 'includes/plugin-update.php';
require_once SC_PLUGIN_PATH . 'includes/admin-menu.php';
require_once SC_PLUGIN_PATH . 'includes/registration.php';
require_once SC_PLUGIN_PATH . 'includes/key-manager.php';
require_once SC_PLUGIN_PATH . 'includes/command-base.php';
require_once SC_PLUGIN_PATH . 'includes/command-dispatcher.php';
require_once SC_PLUGIN_PATH . 'includes/rest-api.php';
require_once SC_PLUGIN_PATH . 'includes/cron.php';

// define the custom wp-admin header bar status indicator...
// Add custom item to the admin bar
add_action('admin_bar_menu', 'custom_admin_bar_icon', 11);
function custom_admin_bar_icon($wp_admin_bar) {
  // Only show for logged-in users
  if (!is_user_logged_in()) return;

  $wp_admin_bar->add_node([
    'id'    => 'custom_admin_icon',
    'title' => '
        <span class="ab-icon">
          <img src="'.SC_PLUGIN_URL.'static/brand_icon.png">
        </span><span class="ab-label">121 Digital Connect</span>',
    'href'  => admin_url('options-general.php?page=site-connector'),
    'meta'  => [
      'title' => 'Go to 121 Digital Connect',
    ],
  ]);
}

// Add custom styles for icon position
add_action('admin_head', 'custom_admin_bar_icon_styles');
function custom_admin_bar_icon_styles() {
  echo '<style>
    #wpadminbar #wp-admin-bar-custom_admin_icon .ab-icon:before {
      font-family: dashicons !important;
    }
    #wpadminbar #wp-admin-bar-custom_admin_icon {
      padding-left: 0 !important;
    }

    .ab-icon img {
      height: 25px !important;
    }
  </style>';
}

// custom styles for frontend wp-admin head..
add_action('wp_head', 'custom_frontend_admin_bar_styles');
function custom_frontend_admin_bar_styles() {
  // Only output on the homepage and if admin bar is visible
  if (is_front_page() && is_admin_bar_showing()) {
    echo '<style>
      #wpadminbar #wp-admin-bar-custom_admin_icon .ab-icon:before {
        font-family: dashicons !important;
      }
      #wpadminbar #wp-admin-bar-custom_admin_icon {
        padding-left: 0 !important;
      }
      .ab-icon img {
        height: 25px !important;
      }
    </style>';
  }
}


// Remove the WordPress logo
add_action('wp_before_admin_bar_render', 'remove_wp_logo', 0);
function remove_wp_logo() {
  global $wp_admin_bar;
  $wp_admin_bar->remove_menu( 'wp-logo' );
}

// // custom theming for wp-admin elements...
// add_action('admin_head', 'custom_admin_sidebar_icon_color');
// function custom_admin_sidebar_icon_color() {
//   echo '<style>
//     /* Top-level menu icons */
//     #adminmenu .wp-menu-image:before {
//       color: #0073aa; /* Change to your desired color */
//     }

//     /* When menu is hovered or active */
//     #adminmenu li.menu-top .wp-menu-image:before,
//     #adminmenu li.menu-top.current .wp-menu-image:before {
//       color: #f60 !important; /* Hover/active color */
//     }

//     /* Submenu hover or active item */
//     #adminmenu .wp-submenu a:hover,
//     #adminmenu .wp-submenu .current {
//       color: #f60 !important;
//     }
//   </style>';
// }

