<?php

  add_action('admin_menu', 'sc_views_contact_requests_view');

  function sc_views_contact_requests_view() {
      add_menu_page(
          'Contact Requests',
          'Contact Requests',
          'edit_posts', // this allows Editors and up
          'sc-contact-requests',
          'sc_views_contact_requests_render_view',
          'dashicons-welcome-view-site',
          26
      );

      // hidden page for view contact form request...
      add_submenu_page(
        '',                           // no parent, hidden page
        'View Contact Request',       // page title
        'View Contact Request',       // menu title (not shown)
        'edit_posts',                 // capability
        'sc-contact-requests-view',   // slug
        'sc_views_contact_requests_view_request_render_view' // callback
    );
    
  }

  function sc_generate_contact_request_view_contact_url($entry) {
    $encodedEntry = sc_contact_entry_encode_url_params($entry);
    $adminUrl = admin_url('admin.php?page=sc-contact-requests-view&e=' . $encodedEntry);
    
    return esc_url($adminUrl);
  }

  function sc_views_contact_requests_render_view() {
      if (!current_user_can('edit_posts')) {
          wp_die(__('You do not have permission to access this page.'));
      }

      // get the contact form requests...
      $contactRequests = sc_contact_forms_get_submissions();

      ?>
        <div class="wrap">
            <h1>Contact Requests</h1>
            <p>Contact requests that have been submitted by your websites visitors.</p>

            <table class="wp-list-table widefat fixed striped" style='max-width: 1200px;'>
              <thead>
                  <tr>
                      <th scope="col"><b>ID</b></th>
                      <th scope="col"><b>Date</b></th>
                      <th scope="col"><b>Contact Info</b></th>
                      <th scope='col'></th>
                  </tr>
              </thead>
              <tbody>
                  <?php if (empty($contactRequests)) : ?>
                      <tr>
                          <td colspan="5">No contact requests found.</td>
                      </tr>
                  <?php else : ?>
                      <?php foreach ($contactRequests as $request) : ?>
                          <tr>
                              <td><?php echo esc_html($request['entry_id']); ?></td>
                              <td><?php echo esc_html(date('Y-m-d H:i:s', strtotime($request['entry_date']))); ?></td>
                              <td><?php echo esc_html(sc_contact_entry_get_from_info($request)); ?></td>
                              <td style='text-align: right;'>
                                <a href='<?php print sc_generate_contact_request_view_contact_url($request); ?>' class='button' style='text-align: right;'>
                                  View Submission
                                </a>
                              </td>
                          </tr>
                      <?php endforeach; ?>
                  <?php endif; ?>
              </tbody>
            </table>
        </div>
      <?php
  }

  function make_readable_without_mf($str) {
    // Remove 'mf-' prefix if it exists
    $str = preg_replace('/^mf-/', '', $str);
    $str = str_replace('-', ' ', $str);
    return ucwords($str);
  }

  function sc_views_contact_requests_view_request_render_row($rowKey, $rowValue) {
    // skip entry ID...
    if($rowKey == 'entry_id') return;

    // make the rowKey readable...


    print "<tr style='max-width: 600px;'>";
    print "<td>".make_readable_without_mf($rowKey)."</td>";
    print "<td>";
    if($rowKey == 'mf-comment') {
      print "<textarea disabled class='regular-text' style='width: 100%; height: 100px; color: black !important;'>{$rowValue}</textarea>";
    }
    else {
      print "<input disabled value='{$rowValue}' class='regular-text' style='width: 100%; color: black !important;' type='text'>";
    }
    print "</td>";
    print "</tr>";
  }

  function sc_views_contact_requests_view_request_render_view() {
    if (!current_user_can('edit_posts')) {
      wp_die(__('You do not have permission to access this page.'));
    }

    // check if we have a URL param..
    if(!isset($_GET['e']) || empty($_GET['e'])) {
      sc_die(__('No contact request ID provided.'));
    }
    $encodedEntry = $_GET['e'];
    $decodedEntry = sc_contact_entry_decode_url_params($encodedEntry);
    $entry = sc_contact_entry_get_entry($decodedEntry);

    ?>
    <div class="wrap">
      <h1>View Contact Request</h1>
      <div class="wp-toolbar" style="margin-bottom: 20px;">
          <a href="<?php echo esc_url(admin_url('admin.php?page=sc-contact-requests')); ?>" class="button button-secondary">
              &larr; Back to Contact Requests
          </a>
      </div>

      <table class="wp-list-table widefat fixed striped" style='max-width: 600px;'>
        <?php foreach($entry as $rowKey => $rowValue) : ?>
          <?php sc_views_contact_requests_view_request_render_row($rowKey, $rowValue); ?>
        <?php endforeach; ?>
      </table>

    </div>
    <?php 
  }
