<?php
  // security options..
add_action('plugins_loaded', 'ccd_maybe_disable_comments');
function ccd_maybe_disable_comments() {
    if (!get_option('sc_security_disable_comments')) {
        return; // ✅ Efficient: skip everything
    }

    // Disable comment support on all post types (except WooCommerce products)
    add_action('admin_init', function () {
        foreach (get_post_types() as $post_type) {
            if ($post_type === 'product') continue;
            if (post_type_supports($post_type, 'comments')) {
                remove_post_type_support($post_type, 'comments');
                remove_post_type_support($post_type, 'trackbacks');
            }
        }
    });

    // Close comment/ping status on front-end
    add_filter('comments_open', '__return_false', 20, 2);
    add_filter('pings_open', '__return_false', 20, 2);
    add_filter('comments_array', '__return_empty_array', 10, 2);

    // Admin cleanup
    add_action('admin_menu', function () {
        remove_menu_page('edit-comments.php');
    });

    add_action('init', function () {
        if (is_admin_bar_showing()) {
            remove_action('admin_bar_menu', 'wp_admin_bar_comments_menu', 60);
        }
    });

    // Disable comment widgets
    add_action('widgets_init', function () {
        unregister_widget('WP_Widget_Recent_Comments');
    });

    // Block REST API comments
    add_filter('rest_endpoints', function ($endpoints) {
        unset($endpoints['/wp/v2/comments']);
        return $endpoints;
    });

    // Disable XML-RPC comment methods
    add_filter('xmlrpc_methods', function ($methods) {
        unset($methods['wp.newComment']);
        unset($methods['wp.getComments']);
        return $methods;
    });

    // Disable comment feeds
    add_action('template_redirect', function () {
        if (is_comment_feed()) {
            wp_die('Comments are disabled.', '', ['response' => 403]);
        }
    });
}