<?php 

  class SC_Security_Options_View {

    public function __construct() {
      add_action('admin_menu', [$this, 'add_security_options_page']);
    }

    public function add_security_options_page() {
      add_menu_page(
        '121 Site Security Options',
        'Site Security',
        'manage_options',
        'site-security-options',
        [$this, 'render_security_options_page'],
        'dashicons-shield-alt',
        100
      );
    }

    public function render_security_options_page() {
      if (!current_user_can('manage_options')) {
        sc_die(__('You do not have sufficient permissions to access this page.'));
      }

      // Handle form submission
      if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Process form data here
        // Handle the disable comments checkbox
        if (isset($_POST['sc_security_option']) && $_POST['sc_security_option'] === 'on') {
          update_option('sc_disable_comments', '1');
        } else {
          update_option('sc_disable_comments', '0');
        }
        // Handle delete all comments button
        if (isset($_POST['sc_delete_all_comments']) && $_POST['sc_delete_all_comments'] === '1') {
          global $wpdb;
          $deleted = $wpdb->query("DELETE FROM {$wpdb->comments}");
          $wpdb->query("DELETE FROM {$wpdb->commentmeta}");
          echo '<div class="updated"><p>All comments have been deleted.</p></div>';
        } else {
          echo '<div class="updated"><p>Security options updated successfully.</p></div>';
        }
      }

      // Get current option value
      $securityOptions = array();

      // check if comments are disabled...
      if(get_option('sc_disable_comments') === '1') {
        $securityOptions['disable_comments'] = true;
      } else {
        $securityOptions['disable_comments'] = false;
      }

      ?>
      <div class="wrap">
        <h1><b>Website Security Options</b></h1>
        <form method="post" action="">
          <table class="form-table">
            <tr valign="top">
              <th scope="row"><label for="sc_security_option">Disable Comments</label></th>
              <td>
                <input type="checkbox" id="sc_security_option" name="sc_security_option" 
                class="regular-text" <?php if($securityOptions['disable_comments']) print "checked"; ?>/>
                <p class="description">This will disable all comments on the site and prevent SPAM attacks.</p>
              </td>
            </tr>
          </table>
          <div style="margin-top: 20px; display: flex; gap: 10px; align-items: center;">
            <?php submit_button('Save Changes', 'primary', 'submit', false); ?>
            <button type="submit" name="sc_delete_all_comments_btn" class="button button-danger" onclick="return confirm('Are you sure you want to delete all comments? This action cannot be undone.');">
              Delete All Comments
            </button>
            <input type="hidden" name="sc_delete_all_comments" value="0" />
          </div>
          <script>
            // Set hidden input to 1 if delete button is clicked
            document.addEventListener('DOMContentLoaded', function() {
              var deleteBtn = document.querySelector('button[name=\'sc_delete_all_comments_btn\']');
              var hiddenInput = document.querySelector('input[name=\'sc_delete_all_comments\']');
              if(deleteBtn && hiddenInput) {
                deleteBtn.addEventListener('click', function() {
                  hiddenInput.value = '1';
                });
              }
            });
          </script>
        </form>
      </div>
      <?php
    }
  }

  $__SC_security_options_view = new SC_Security_Options_View();