<?php 

  // Create custom role: reg121_user
function sc_create_reg121_user_role() {
  // Remove existing role (optional, useful during development)
  remove_role('reg121_user');

  add_role('reg121_user', 'REG121 User', [
      'read' => true,
      'edit_posts' => true,
      'edit_pages' => true,
      'edit_others_posts' => true,
      'edit_published_posts' => true,
      'edit_others_pages' => true,
      'edit_published_pages' => true,
      'publish_posts' => true,
      'publish_pages' => true,
      'upload_files' => true, // Media Library
      'read_private_pages' => true,
      'read_private_posts' => true,

      // Elementor-related permissions
      'edit_elementor_templates' => true,
      'manage_options' => true,
      'edit_theme_options' => true, // Required for Elementor Settings
  ]);
}
add_action('init', 'sc_create_reg121_user_role');

// Add Elementor-specific capabilities
function sc_grant_reg121_user_elementor_caps() {
  $role = get_role('reg121_user');
  if (!$role) return;

  $role->add_cap('edit_elementor_templates');
  // Uncomment the next line only if Elementor Pro requires it and you're okay with some extra access
  // $role->add_cap('edit_theme_options');
}
add_action('init', 'sc_grant_reg121_user_elementor_caps');

// Optional: Clean up admin menu for reg121_user
function sc_hide_admin_menus_for_reg121_user() {
  if (!current_user_can('reg121_user')) return;

  remove_menu_page('tools.php');
  remove_menu_page('plugins.php');
  remove_menu_page('themes.php');
  remove_menu_page('options-general.php');
  remove_menu_page('users.php');
}
add_action('admin_menu', 'sc_hide_admin_menus_for_reg121_user', 999);

// Redirect reg121_user away from profile.php
function sc_block_profile_page_for_reg121_user() {
  if (
      current_user_can('reg121_user') &&
      is_admin() &&
      isset($_SERVER['REQUEST_URI']) &&
      strpos($_SERVER['REQUEST_URI'], 'profile.php') !== false
  ) {
      wp_redirect(admin_url());
      exit;
  }
}
add_action('admin_init', 'sc_block_profile_page_for_reg121_user');

// Remove "Profile" from admin menu
function sc_remove_profile_menu_for_reg121_user() {
  if (current_user_can('reg121_user')) {
      remove_menu_page('profile.php');
  }
}
add_action('admin_menu', 'sc_remove_profile_menu_for_reg121_user', 999);

// Remove "Edit My Profile" from admin bar
function sc_remove_admin_bar_profile_links_for_reg121_user($wp_admin_bar) {
  if (current_user_can('reg121_user')) {
      $wp_admin_bar->remove_node('edit-profile');
      $wp_admin_bar->remove_node('user-info');
  }
}
add_action('admin_bar_menu', 'sc_remove_admin_bar_profile_links_for_reg121_user', 999);

function sc_whitelist_admin_menu_items() {
  $user = wp_get_current_user();
  if (!in_array('reg121_user', (array) $user->roles)) return;

  global $menu;

  // Keep only these top-level menus
  $whitelist = [
      'index.php',           // Dashboard
      'edit.php',            // Posts
      'edit.php?post_type=page', // Pages
      'upload.php',          // Media
      'elementor',           // Elementor
      'edit.php?post_type=elementor_library',
      'sc-contact-requests'
  ];

  foreach ($menu as $key => $item) {
      $slug = $item[2];
      if (!in_array($slug, $whitelist)) {
          remove_menu_page($slug);
      }
  }
}
add_action('admin_menu', 'sc_whitelist_admin_menu_items', 1000);

