<?php 

  function sc_contact_forms_has_metforms_tables() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'mf_submissions';
    $table_exists = $wpdb->get_var("SHOW TABLES LIKE '{$table_name}'") === $table_name;
    
    return $table_exists;
  } 

  function sc_contact_forms_get_metform_submissions() {
    $args = [
        'post_type'      => 'metform-entry',
        'post_status'    => 'publish', // or 'any' if you want drafts/trash too
        'posts_per_page' => -1,
        'orderby'        => 'date',
        'order'          => 'DESC',
    ];

    $query = new WP_Query($args);
    $processedMetformEntries = array();
    foreach($query->posts as $metformEntryPost) {
      $metformEntry = get_post_meta($metformEntryPost->ID, 'metform_entries__form_data', true);
      array_push($processedMetformEntries, array(
        "entry_id"   => $metformEntryPost->ID,
        "entry_data" => $metformEntry,
        'entry_date' => $metformEntryPost->post_date,
      ));
    }

    return $processedMetformEntries; // returns array of WP_Post objects
  }

  function sc_contact_forms_get_metform_submissions_today() {
    $today = date('Y-m-d');
    $args = [
        'post_type'      => 'metform-entry',
        'post_status'    => 'publish',
        'posts_per_page' => -1,
        'orderby'        => 'date',
        'order'          => 'DESC',
        'date_query'     => [
            [
                'after'     => $today . ' 00:00:00',
                'before'    => $today . ' 23:59:59',
                'inclusive' => true,
            ],
        ],
    ];

    $query = new WP_Query($args);
    $processedMetformEntries = [];

    foreach ($query->posts as $metformEntryPost) {
        $rawMeta = get_post_meta($metformEntryPost->ID, 'metform_entries__form_data', true);
        $entryData = $rawMeta;

        $processedMetformEntries[] = [
            'entry_id'   => $metformEntryPost->ID,
            'entry_date' => $metformEntryPost->post_date,
            'entry_data' => $entryData,
        ];
    }

    return $processedMetformEntries;
  }

  function sc_contact_forms_get_submissions() {
    $itemisedSubmissions = array();
    $metformSubmissions = sc_contact_forms_get_metform_submissions();
    foreach($metformSubmissions as $metformSubmission) {
      $metformSubmission['form_type'] = 'metform';

      array_push($itemisedSubmissions, $metformSubmission);
    }

    return $itemisedSubmissions;

  }

  function sc_contact_forms_get_submissions_today() {
    $itemisedSubmissions = array();
    $metformSubmissions = sc_contact_forms_get_metform_submissions_today();
    foreach($metformSubmissions as $metformSubmission) {
      $metformSubmission['form_type'] = 'metform';

      array_push($itemisedSubmissions, $metformSubmission);
    }

    return $itemisedSubmissions;

  }

  function sc_contact_entry_get_from_info($form_entry) {
    $entryFromInfo = "Unknown";
    
    if(!isset($form_entry)) {
      return $entryFromInfo;
    }
    if(!isset($form_entry['entry_data'])) {
      return $entryFromInfo;
    }
    $form_data = $form_entry['entry_data'];

    // the rest depends on the contact form type...
    if($form_entry['form_type'] == 'metform') {
      // check if we have an email...
      if(isset($form_data['mf-email'])) {
        $entryFromInfo = $form_data['mf-email'];
      }
      else if(isset($form_data['mf-first-name'])) {
        if(isset($form_data['mf-last-name'])) {
          $entryFromInfo = $form_data['mf-first-name'] . " " . $form_data['mf-last-name'];
        }
        else {
          $entryFromInfo = $form_data['mf-first-name'];
        }
      }
      else if(isset($form_data['mf-phone'])) {
        $entryFromInfo = $form_data['mf-phone'];
      }
 
    }

    return $entryFromInfo;
  }

  function sc_contact_entry_encode_url_params($form_entry) {
    try {
      $formEntryId = $form_entry['entry_id'];
      $formType    = $form_entry['form_type'];
  
      $decodedData = json_encode(array(
        "form_type"     => $formType,
        "form_entry_id" => $formEntryId,
      ));
      return base64_encode($decodedData);
    }
    catch(Exception $e) {
      sc_die($e->getMessage());
    }
  }

  function sc_contact_entry_decode_url_params($url_params) {
    try {
      $decodedData = base64_decode($url_params);
      $data = json_decode($decodedData, true);
  
      if (isset($data['form_type']) && isset($data['form_entry_id'])) {
        return array(
          'form_type'     => $data['form_type'],
          'form_entry_id' => $data['form_entry_id'],
        );
      }
  
      throw new Exception('Provided contact form entry URL data is invalid.');
    }
    catch(Exception $e) {
      sc_die($e->getMessage());
    }
  }

  function sc_contact_entry_get_entry($entry) {
    if($entry['form_type'] == 'metform') {
      $entryId = $entry['form_entry_id'];
      $metformEntry = get_post_meta($entryId, 'metform_entries__form_data', true);
      $metformEntry['entry_id'] = $entryId;
      $metformEntry['entry_date'] = get_post($entryId)->post_date;
      return $metformEntry;
    }
    else {
      sc_die("Unsupported contact form type: " . $entry['form_type']);
    }
  }