<?php

/**
 * Class SC_Commamd_Plugin_Update
 * 
 * Handles the execution of a plugin update check using the 
 * Plugin Update Checker (PUC) library.
 */
class SC_Commamd_Plugin_Update extends SC_Command_Base {

  /**
   * Executes the plugin update process.
   *
   * @return array Associative array with success status, message, and data.
  */
  public function execute() {
    try {
      // Access the global plugin update checker instance
      global $_SC_plugin_update_checker;

      // Ensure the update checker is initialized
      if (!isset($_SC_plugin_update_checker)) {
        throw new Exception('Could not init 121Connect plugin update service.');
      }

      $pluginUpdateChecker = $_SC_plugin_update_checker;

      // Trigger a check for plugin updates
      $pluginUpdateChecker->checkForUpdates();

      // Return a success response
      $response = array(
        "success" => true,
        "message" => "The plugin update check has been completed.",
        "data"    => array()
      );
      return $response;
    }
    catch (Exception $e) {
      // Return a failure response if an error occurs
      $response = array(
        "success" => false,
        "message" => "The plugin could not be updated.",
        "data"    => array()
      );
      return $response;
    }
  }
}
