<?php

  $_sc_whitelist_dashboard_widgets = array(
    "sc_custom_dashboard_widget",
    "sc_recent_pages_dashboard_widget",
    "sc_quick_create_dashboard_widget",
    "sc_performance_dashboard_widget"
  );

  //Remove all existing dashboard widgets except ours
  function sc_remove_all_other_dashboard_widgets() {
    global $wp_meta_boxes;
    global $_sc_whitelist_dashboard_widgets;

    // Remove all widgets from the 'dashboard' context
    if ( isset( $wp_meta_boxes['dashboard'] ) ) {
        foreach ( $wp_meta_boxes['dashboard'] as $context => $priorities ) {
            foreach ( $priorities as $priority => $boxes ) {
                foreach ( $boxes as $id => $box ) {
                    // Remove all widgets except our custom widget ID
                    if (!in_array($id, $_sc_whitelist_dashboard_widgets)) {
                        remove_meta_box( $id, 'dashboard', $context );
                    }
                }
            }
        }
    }
  }
  add_action('wp_dashboard_setup', 'sc_remove_all_other_dashboard_widgets', 1000); // Run l

  // Remove default dashboard widgets
  function sc_remove_default_dashboard_widgets() {
    remove_meta_box('dashboard_quick_press', 'dashboard', 'side');       // Quick Draft
    remove_meta_box('dashboard_primary', 'dashboard', 'side');           // WordPress News
    remove_meta_box('dashboard_activity', 'dashboard', 'normal');        // Activity
    remove_meta_box('dashboard_right_now', 'dashboard', 'normal');       // At a Glance
    remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal'); // Recent Comments
    remove_meta_box('dashboard_incoming_links', 'dashboard', 'normal');  // Incoming Links
    remove_meta_box('dashboard_plugins', 'dashboard', 'normal');         // Plugins
  }
  add_action('wp_dashboard_setup', 'sc_remove_default_dashboard_widgets');

  // Add a custom dashboard widget
  function sc_add_custom_dashboard_widget() {
    wp_add_dashboard_widget(
        'sc_custom_dashboard_widget',
        'Welcome to REG121 Website Builder Dashboard',
        'sc_custom_dashboard_widget_content'
    );
  }

  function sc_custom_dashboard_widget_content() {
    echo '<img src="' . esc_url(SC_PLUGIN_URL . '/static/reg121_brand.svg') . '" alt="REG121 Logo" style="width: 250px; height: auto; margin-top: 20px; margin-bottom: 5px;">';
    echo '<p>This dashboard is your control center for managing your website.</p>';

    echo '<h3><b>Basic Site Management</b></h3>';
    echo '<ul>';
    echo '<li><strong>Pages & Posts:</strong> Create, edit, and organize your site content easily.</li>';
    echo '<li><strong>Media Library:</strong> Upload and manage images, videos, and files.</li>';
    echo '<li><strong>Elementor:</strong> Use Elementor to design beautiful pages with drag-and-drop.</li>';
    echo '<li><strong>Settings:</strong> Customize your site appearance and functionality.</li>';
    echo '</ul>';

    echo '<h3><b>Getting Started Tips</b></h3>';
    echo '<ul>';
    echo '<li>Use the "Pages" menu to add new pages like Home, About, or Contact.</li>';
    echo '<li>Upload your logo and images in the Media Library for branding.</li>';
    echo '<li>Explore Elementor to build custom layouts without coding.</li>';
    echo '<li>Regularly update your content to keep your site fresh and engaging.</li>';
    echo '</ul>';

    echo '<p>If you have any questions or need support, please contact your site administrator.</p>';
  }
  add_action('wp_dashboard_setup', 'sc_add_custom_dashboard_widget');

  // Add dashboard widget for recent pages with Elementor edit button
  function sc_add_recent_pages_dashboard_widget() {
    wp_add_dashboard_widget(
        'sc_recent_pages_dashboard_widget',
        'Recent Pages',
        'sc_render_recent_pages_dashboard_widget',
        null,
        null,
        'side',
        'high'
    );
  }

  function sc_render_recent_pages_dashboard_widget() {
    // Get last 10 pages
    $recent_pages = get_posts([
        'post_type'      => 'page',
        'posts_per_page' => 10,
        'orderby'        => 'date',
        'order'          => 'DESC',
    ]);

    if (empty($recent_pages)) {
        echo '<p>No recent pages found.</p>';
        return;
    }

    echo '<table style="width: 100%; border-collapse: collapse;">';
    echo '<thead><tr>';
    echo '<th style="text-align:left; padding:4px;">Title</th>';
    echo '<th style="text-align:left; padding:4px;">Published</th>';
    echo '<th style="text-align:left; padding:4px;">Actions</th>';
    echo '</tr></thead><tbody>';

    foreach ($recent_pages as $page) {
        $edit_link = get_edit_post_link($page->ID);
        $published_date = get_the_date('', $page->ID);

        // Default "Edit" button
        $buttons = '<a class="button" href="' . esc_url($edit_link) . '">Edit</a> ';

        // Check if Elementor is active and page built with Elementor
        $uses_elementor = get_post_meta($page->ID, '_elementor_edit_mode', true) === 'builder';
        if ($uses_elementor) {
            $elementor_edit_link = admin_url('post.php?post=' . $page->ID . '&action=elementor');
            $buttons = '<a style="width: 150px; text-align: center;" class="button button-primary" href="' . esc_url($elementor_edit_link) . '" target="_blank">
                         <span style="margin-top: 3px;" class="dashicons dashicons-edit"></span> Page Editor
                        </a>
            ';
        }
        else {
          $buttons = '<a style="width: 150px; text-align: center;" class="button" href="' . esc_url($edit_link) . '">Classic Editor</a> ';
        }

        echo '<tr>';
        echo '<td style="padding:4px;"><a href="' . esc_url($edit_link) . '">' . esc_html($page->post_title) . '</a></td>';
        echo '<td style="padding:4px;">' . esc_html($published_date) . '</td>';
        echo '<td style="padding:4px;">' . $buttons . '</td>';
        echo '</tr>';
    }

    echo '</tbody></table>';
  }
  add_action('wp_dashboard_setup', 'sc_add_recent_pages_dashboard_widget');

  // Register the Quick Create dashboard widget
  function sc_add_quick_create_dashboard_widget() {
    wp_add_dashboard_widget(
        'sc_quick_create_dashboard_widget',
        'Quick Create',
        'sc_render_quick_create_dashboard_widget',
        null,
        null,
        'side',
        'high'
    );
  }
  add_action('wp_dashboard_setup', 'sc_add_quick_create_dashboard_widget');

  // Render widget content
  function sc_render_quick_create_dashboard_widget() {
    ?>
    <style>
        .sc-quick-create-btns {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-top: 10px;
        }
        .sc-quick-create-btns a.button {
            flex: 1 0 30%;
            text-align: center;
        }
    </style>
    <p>Quickly create content or start editing with REG121 Web BuilderPro:</p>
    <div class="sc-quick-create-btns">
        <a href="<?php echo admin_url('post-new.php?post_type=page'); ?>" class="button button-primary">
          <span style='margin-top: 5.5px;' class="dashicons dashicons-plus"></span> New Page
        </a>
        <a href="<?php echo admin_url('post-new.php'); ?>" class="button">
          <span style='margin-top: 5.5px;' class="dashicons dashicons-plus"></span> New Blog Post
        </a>
        <a href="<?php echo admin_url('post-new.php?post_type=page&action=elementor'); ?>" class="button">
          <span style='margin-top: 5.5px;' class="dashicons dashicons-plus"></span> New Builder Page
        </a>
    </div>
    <?php
  }

  function sc_add_performance_dashboard_widget() {
    wp_add_dashboard_widget(
        'sc_performance_dashboard_widget',
        'Site Performance',
        'sc_render_performance_dashboard_widget',
        null,
        null,
        'side'
    );
  }
  add_action('wp_dashboard_setup', 'sc_add_performance_dashboard_widget');

  function sc_render_performance_dashboard_widget() {
    $total_count = count(sc_contact_forms_get_submissions());
    $today_count = count(sc_contact_forms_get_submissions_today());

    $viewContactRequestsAdminUrl = admin_url('admin.php?page=sc-contact-requests');
    $viewContactRequestsUrl = esc_url($viewContactRequestsAdminUrl);

    echo '<div style="display: flex; gap: 20px;">';
    
    echo '<div style="flex: 1; padding: 12px 15px; background: #f1f1f1; border-left: 4px solid #0073aa; display: flex; flex-direction: column; justify-content: center;">';
    echo '<h3 style="margin: 0 0 5px; font-size: 16px;">Total Contact Requests</h3>';
    echo '<p style="margin: 0; font-size: 20px; font-weight: bold;">' . $total_count . '</p>';
    echo '</div>';

    echo '<div style="flex: 1; padding: 12px 15px; background: #f1f1f1; border-left: 4px solid #00a32a; display: flex; flex-direction: column; justify-content: center;">';
    echo '<h3 style="margin: 0 0 5px; font-size: 16px;">Today\'s Contact Requests</h3>';
    echo '<p style="margin: 0; font-size: 20px; font-weight: bold;">' . $today_count . '</p>';
    echo '</div>';

    echo '</div>';

    echo "<br>";
    echo '<a href='.$viewContactRequestsUrl.' class="button">View Contact Requests</a>';

  }



