<?php 

  class SC_Command_Matomo_Set_Tracking_Code extends SC_Command_Base {
  
    public function execute() {
      try {
        if(function_exists('sc_matomo_set_tracking_code')) {
          if(!isset($this->args['tracking_code'])) {
            throw new Exception('The tracking code is required.');
          }

          $trackingCode = $this->args['tracking_code'];

          sc_matomo_set_tracking_code($trackingCode);
          $response = array(
            "success" => true,
            "message" => "The tracking code has been updated.",
            "data"    => array()
          );
          return $response;
        }
        else {
          throw new Exception('The plugin could not set the tracking code.');
        }
      }
      catch(Exception $e) {
        $response = array(
          "success" => false,
          "message" => "The plugin could not set the tracking code.",
          "data"    => array()
        );
        return $response;
      }
    }
  }